<?php defined('MW_PATH') || exit('No direct script access allowed'); ?>
 
<?php
/**
 * This file is part of the MailWizz EMA application.
 * 
 * @package MailWizz EMA
 * @author Serban George Cristian <cristian.serban@mailwizz.com> 
 * @link http://www.mailwizz.com/
 * @copyright 2013-2014 MailWizz EMA (http://www.mailwizz.com)
 * @license http://www.mailwizz.com/license/
 * @since 1.0
 */

/**
 * This hook gives a chance to prepend content or to replace the default view content with a custom content.
 * Please note that from inside the action callback you can access all the controller view
 * variables via {@CAttributeCollection $collection->controller->data}
 * In case the content is replaced, make sure to set {@CAttributeCollection $collection->renderContent} to false 
 * in order to stop rendering the default content.
 * @since 1.3.3.1
 */
$hooks->doAction('before_view_file_content', $viewCollection = new CAttributeCollection(array(
    'controller'    => $this,
    'renderContent' => true,
)));

// and render if allowed
if ($viewCollection->renderContent) {
    /**
     * This hook gives a chance to prepend content before the active form or to replace the default active form entirely.
     * Please note that from inside the action callback you can access all the controller view variables 
     * via {@CAttributeCollection $collection->controller->data}
     * In case the form is replaced, make sure to set {@CAttributeCollection $collection->renderForm} to false 
     * in order to stop rendering the default content.
     * @since 1.3.3.1
     */
    $hooks->doAction('before_active_form', $collection = new CAttributeCollection(array(
        'controller'    => $this,
        'renderForm'    => true,
    )));
    
    // and render if allowed
    if ($collection->renderForm) {
        $form = $this->beginWidget('CActiveForm',array('focus'=>array($model,Yii::app()->controller->focus))); 
        ?>
		<div class="breadcrumbs" style="margin-left:0px;">
		<a href="<?php echo Yii::app()->createUrl('');?>/">Home</a> &rsaquo; <a href="<?php echo Yii::app()->createUrl('place_an_ad/create');?>">Place Ad</a>
		</div>
        <div class="clear"></div>
        <div class="box box-primary">
            <div class="box-header">
                <div class="pull-left">
                <h1 id="innerhead">Place Your Ad</h1> 
                </div>
         
                <div class="clearfix"><!-- --></div>
            </div>
            <div class="box-body">
                <?php 
                /**
                 * This hook gives a chance to prepend content before the active form fields.
                 * Please note that from inside the action callback you can access all the controller view variables 
                 * via {@CAttributeCollection $collection->controller->data}
                 * @since 1.3.3.1
                 */
                $hooks->doAction('before_active_form_fields', new CAttributeCollection(array(
                    'controller'    => $this,
                    'form'          => $form    
                )));
                ?>
          

                <div class="clearfix"><!-- --></div>
				<ul  class="fourStep stepNavigation" style="width:100%;">
					<li class="current"><a title=""><em>Step 1: Ad Type</em><span>Choose Ad Type</span></a></li>
					<li><a title=""><em>Step 2: Details</em><span>Enter Ad details</span></a></li>
					<li><a title=""><em>Step 3: Location</em><span>Choose Location<span></a></li>
					<li class="lastStep"><a title=""><em>Step 4: Done</em><span>Completed</span></a></li>
	           </ul>
	           <div style="clear:both"></div>
                <div class="content_place_an_ad">
					   <div class="content_head">Step 1 : Choose Ad Type</div> 
					   <div style="clear:both"></div>
				       <div class="content_content">
						 <div style="clear:both"></div>
					    <?php /* <div style="font-size:14px;font-weight:bold;margin-bottom:5px;" class="wid4_head1"><u>Choose Location</u></div>*/ ?>
						 <div style="clear:both"></div>
						 <div>
						  <div class='wid4_head1 disabled' id="country"></div><div class="wid4_median1"></div>
						  <div class='wid4_head1 disabled' id="state"></div> 
						 </div>
						  <div style="clear:both"></div>
						  <?php /*  <div style="font-size:14px;font-weight:bold;margin-bottom:5px;" class="wid4_head1"><u>Choose Ad Type</u></div>*/ ?>
						 <div style="clear:both"></div>
						  <div>
								<div id="section" class="wid"></div>
								<div class="wid2 wid4"></div>
								<div id="category_sel" class="wid"></div>
								<div class="wid2 wid5"></div>
								<div id="sub_category_sel" class="wid"></div>
								<div class="wid2 wid6"></div>
								<div id="model_wid" class="wid"></div>
						  <div style="clear:both"></div>
						 </div> <input type="checkbox" class="myClass" value="yes" id="answer" onchange="checkDisabled(this)" name="answer"/> 
					 </div>
					
						
					 <div class="step_content_title2"><h1>Agree to terms</h1></div>
					 
					 
					 <div class="step_content_box">
						<div class="step_content_left">
							<h2>Before placing your ad…</h2>
							<p>
							By listing in this section you agree that you will
							<b>NOT</b>
							do the following:
							</p>
							<ul style="width:370px;">
							<li>
							Same advertisement should not twice
							<span> twice.</span>
							</li>
							<li>
							Advertisement should not be in
							<span>numerous categories .</span>
							</li>
							<li>
							Place an advertisement should not be in
							<span>wrong category.</span>
							</li>
							</ul>
						</div>
						<div class="step_content_right">
							<div class="tag_1">
							<span>
							<img border="0" alt="" src="<?php  echo Yii::app()->baseUrl."/frontend/assets/img/heart_1.png";?>">
							</span>
							<p>Users who violate these rules will have their ads removed and may have their accounts permanently suspended.</p>
							</div>
							<div class="tag_2">
							<span>
							<img border="0" alt="" src="<?php  echo Yii::app()->baseUrl."/frontend/assets/img/heart_1.png";?>">
							</span>
							<p>
							<b>OK, we’re done being mean now.</b>
							</p>
							</div>
							<div class="btn2">
							
							 <button class="next2 btn_my" disabled="true"> Next </button>
							 
							</div>
						</div>
				</div>
					 
					 
					 
					 
					 
					 
					 
					 <div style="clear:both;"></div>
					 
					 
					 
					  
				 </div>
				<?php echo $form->hiddenField($model, 'country'); ?>
				<?php echo $form->hiddenField($model, 'state'); ?>
				<?php echo $form->hiddenField($model, 'category_id'); ?>
				<?php echo $form->hiddenField($model, 'sub_category_id'); ?>
				<?php echo $form->hiddenField($model, 'model'); ?>
                <script type="text/javascript">  
				var sel = false;
		        var check= false;
		        var model = false;
		        var subcategoryNeeded = false;
               $.noConflict();
            $(document).ready(function () {
                var country =  <?= $country ;?>; 
		        var state = <?=CJSON::encode( array('0'=>"&nbsp;Select Region"));?>; 
		        var state = <?= $state ;?>; 
		        var section = <?=CJSON::encode( array('0'=>"&nbsp;Select section"));?>; 
		        var section2 = <?= $section ;?>; 
		        var category = <?=CJSON::encode( array('0'=>"Select Category"));?>;   
		        var category = <?= $category; ?>;   
		        var subcategory = <?=CJSON::encode( array('0'=>"Select Sub Category"));?>;   
		        var subcategory = <?= $sub_category_ars ?>;  
               
                //jqx combobox
                
                $("#country").jqxDropDownList({  source: country,selectedIndex:0,  displayMember: "name", valueMember: "id", width: '200px', height: '25px'  });
                $("#country").jqxDropDownList('selectItem', '<?php echo $model->country;?>' );
                $("#state").jqxDropDownList({  source: state,selectedIndex:0,  displayMember: "name", valueMember: "id", width: '200px', height: '25px' });
                $("#state").jqxDropDownList('selectItem', '<?php echo $model->state;?>' );
               //jqx list box
               
               $("#section").jqxListBox({    selectedIndex: 0,  source: section2, displayMember: "name", valueMember: "id", width: 200, height: 250});
               $("#section").jqxListBox('selectItem', '<?php echo $model->section_id;?>' );
              
               $("#category_sel").jqxListBox({  selectedIndex: 0,displayMember: "name", valueMember: "id", source: category, width: 200, height: 250});
               $("#category_sel").jqxListBox('selectItem', '<?php echo $model->category_id;?>' )
               
              // $("#sub_category_sel").jqxListBox({  selectedIndex: 0, source: subcategory,displayMember: "name", valueMember: "id", width: 200, height: 250});
              
              
              
               $("#section,#category_sel,#sub_category_sel").jqxListBox('disableAt', 0 ); 
               $("#country,#state").jqxDropDownList('disableAt', 0 ); 
               
               
               
                //country chnge
                $('#country').on('select', function (event) {
					$(".wid4_median1").addClass("wid3_median1");
					var args = event.args;
					
					if (args) {
						   var value = args.item.value;
						   $("#PlaceAnAd_country").val(value);
						   $.post("<?php echo Yii::app()->createUrl('place_an_ad/select_state'); ?>",{"country":value},function(data){ 
								  $("#state").jqxDropDownList({  source:JSON.parse(data)  , selectedIndex:0,displayMember: "name", valueMember: "id", width: '200px', height: '25px' });
								  $("#state").jqxDropDownList('disableAt', 0 ); 
								  $("#PlaceAnAd_state").val(""); 
								   $(".wid4_median1").removeClass("wid3_median1");
								  } )
					  };
				
			   });
			   //state
               $('#state').on('select', function (event) {
				 
				var args = event.args;
				$(".wid2").addClass("wid3");
				if (args && !isNaN(parseInt(args.item.value))) {
					   var value = args.item.value;
					    $("#PlaceAnAd_state").val(value);
					   $("#section").jqxListBox({    source: section2 , width: 200, height: 250});  
					   $("#section").jqxListBox('disableAt', 0 );
				}
				else if(args.item.value=="All Cities")
				{
					 
					   var value = args.item.value;
					   $("#PlaceAnAd_state").val(0);
					   $("#section").jqxListBox({    source: section2 , width: 200, height: 250});  
					   $("#section").jqxListBox('disableAt', 0 );
				}
				
				$(".wid2").removeClass("wid3");
				
			   });
			   
			   		
		 
                
           
               
               $('#section').on('change', function (event) {
				// the event is raised when the selection is changed.
				
				var args = event.args;
				if (args && !isNaN(parseInt(args.item.value))) {
					$(".wid4").addClass("wid3");
					$('#model_wid').jqxListBox('clear');
					$("#PlaceAnAd_model").val("");
					$('#model_wid').hide();
					$(".next2").attr("disabled");
					  sel = false;
					  var value = args.item.value;
					  $.post("<?php echo Yii::app()->createUrl('place_an_ad/select_category'); ?>",{"section":value},function(data){  
						   $("#category_sel").jqxListBox({    source: JSON.parse(data) ,displayMember: "name", valueMember: "id"});
						  
							$("#category_sel,#sub_category_sel").jqxListBox('disableAt', 0 ); 
							$(".wid4").removeClass("wid3"); 
							$(".next2").attr("disabled",true);
							sel = false;
							// $("#sub_category_sel").jqxListBox({  selectedIndex: 0, source: subcategory, width: 200, height: 250});
							$('#sub_category_sel').jqxListBox('clear');
							$('#sub_category_sel').hide();
							$("#PlaceAnAd_sub_category_id").val("");
						   } );
				}
				 
			});
               
               
               
               
               
               
               
                // Create a jqxListBox
               
                 
                
			 
		
			 
				$('#category_sel').on('change', function (event) {
				// the event is raised when the selection is changed.
				
				 
				
				
				var args = event.args;
				if (args && !isNaN(parseInt(args.item.value))) {
					
				 
					$(".wid5").addClass("wid3");
					$('#model_wid').jqxListBox('clear');
					$("#PlaceAnAd_model").val("");
					$('#model_wid').hide();
					  $(".next2").attr("disabled");
					  sel = false;
					  subcategoryNeeded = false; 
					  var value = args.item.value;
					  $("#PlaceAnAd_category_id").val(value);
					  $.post("<?php echo Yii::app()->createUrl('place_an_ad/select_sub_category'); ?>",{"category":value},
					  function(data){
						    if(data!='["Select Subcategory"]') {   
									$('#sub_category_sel').show();
									$("#sub_category_sel").jqxListBox({   source: JSON.parse(data) ,width: 200, height: 250, displayMember: "name", valueMember: "id"});
									$("#sub_category_sel").jqxListBox('disableAt', 0 );
									$(".wid5").removeClass("wid3");
									
									$.get("<?php echo Yii::app()->createUrl('place_an_ad/checkModel'); ?>?id="+value ,function(data){ if(parseInt(data)==1){   model = true; }else{ model = false; } } )
									$(".next2").attr("disabled",true);
									sel = false;
									$("#PlaceAnAd_sub_category_id").val(""); 
								 
						     }
						     else
						     { 
									$('#sub_category_sel').jqxListBox('clear');
									$('#sub_category_sel').hide();
						 
									$("#PlaceAnAd_sub_category_id").val("");
									$(".wid5").removeClass("wid3");
									sel =true;
									UncheckValue(sel,check);
								 
							 } 
				} )
				     
				}
				 
			 });
			
				$('#sub_category_sel').on('change', function (event) {
				 
				if(model  &&  args && !isNaN(parseInt(args.item.value)))
					  {
						   $(".wid6").addClass("wid3");
						   var value = args.item.value; 
						   $.get("<?php echo Yii::app()->createUrl('place_an_ad/select_model'); ?>?id="+value ,function(data){   
							   
							    if(parseInt(data)==0)
							    {
									 
									$("#PlaceAnAd_sub_category_id").val(value);
									$('#model_wid').jqxListBox('clear');
									$('#model_wid').hide();
									$("#PlaceAnAd_model").val("");
									$(".wid6").removeClass("wid3");
									sel =true;
									UncheckValue(sel,check);

								}
								else
								{
									$("#PlaceAnAd_sub_category_id").val(value);
									$("#model_wid").jqxListBox({    source: JSON.parse(data) ,displayMember: "name", valueMember: "id", width: 200, height: 250 }); $("#model_wid").jqxListBox('disableAt', 0 ); $(".wid2").removeClass("wid3");
						     	    $("#PlaceAnAd_model").val("");
						     	    $('#model_wid').show();
						     	}
						     	$(".wid6").removeClass("wid3");
						     	
							    } )
				   
					  }
				else if(args && !isNaN(parseInt(args.item.value))) {
					    // $(".next2").removeAttr("disabled");
					    
						sel =true;
						UncheckValue(sel,check);
					     var value = args.item.value;
					      $("#PlaceAnAd_model").val("");
					     $("#PlaceAnAd_sub_category_id").val(value);
					   
				}
				 
			});
							
			$('#model_wid').on('change', function (event) {
				 
				if (args && !isNaN(parseInt(args.item.value))) {
					 
					     sel =true;
					     UncheckValue(sel,check);
					    var value = args.item.value;
						$(".wid2").removeClass("wid3");
					    $(".btn").removeAttr("disabled");
					    var value = args.item.value;
					    $("#PlaceAnAd_model").val(value);
				}
				
				});
		
			   $("#section").hover(function(){ $("#section").jqxListBox('focus'); })
               $("#category_sel").hover(function(){ $("#category_sel").jqxListBox('focus'); })
               $("#sub_category_sel").hover(function(){ $("#sub_category_sel").jqxListBox('focus'); })
               $("#model_wid").hover(function(){ $("#model_wid").jqxListBox('focus'); })
               $("#country").hover(function(){ $("#country").jqxDropDownList('focus'); })
               $("#state").hover(function(){ $("#state").jqxDropDownList('focus'); })
			
            });
            
            $().ready(function(){

  $('input.myClass').prettyCheckable({
    color: 'red',
    label:"Agree terms and conditions",
  });

});
	function  checkDisabled(k)
				{
				  if($(k).is(":checked"))
				  {
					 check = true;
					 UncheckValue();
				  }
				  else
				  {
					  check = false;
					  UncheckValue();
				  }
				}
	function UncheckValue()
	{
		if(sel && check)
		{
		 
			 $(".next2").removeAttr("disabled");
		}
		else
		{
			 
			 $(".next2").attr("disabled",true) ;
			 
		}
	}

        </script>
      
     
  </div>
          
        </div>
        <?php 
        $this->endWidget(); 
    }
    /**
     * This hook gives a chance to append content after the active form.
     * Please note that from inside the action callback you can access all the controller view variables 
     * via {@CAttributeCollection $collection->controller->data}
     * @since 1.3.3.1
     */
    $hooks->doAction('after_active_form', new CAttributeCollection(array(
        'controller'      => $this,
        'renderedForm'    => $collection->renderForm,
    )));
}
/**
 * This hook gives a chance to append content after the view file default content.
 * Please note that from inside the action callback you can access all the controller view
 * variables via {@CAttributeCollection $collection->controller->data}
 * @since 1.3.3.1
 */
$hooks->doAction('after_view_file_content', new CAttributeCollection(array(
    'controller'        => $this,
    'renderedContent'   => $viewCollection->renderContent,
)));
?>
 
</div>
</div>
